//=============================================================================
// MenuPetStats
//=============================================================================
class PartDisplayWindow expands MenuUIWindow;

var PartsBag PartsBag;
var DeusExPlayer Player;
var MSMassEffectMutator Mutator;

var MenuUIActionButtonWindow exitButton, WorkbenchButton;
var localized string exitButtonText;

var TileWindow                winTile;
var bool bFilledList;

var int LastParts;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------


function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 /*if (key == IK_M)
  {
   TNMDreamScapePlayer(Ralph.Owner).ShowImagesWindow();
   return true;
  }*/
 return false;
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 /*if (key == IK_M)
  {
   TNMDreamScapePlayer(Ralph.Owner).ShowImagesWindow();
   return true;
  }*/
 return false;
}

function UpdateInfo()
{
	CreatePartsList();

 SetTitle("|p4"$GetNumParts(Player)$" Parts; "$Mutator.CurScrap$" Scrap");
}

function CreatePartsTileWindow()
{
        winTile = CreateScrollTileWindow(18, 4, 348, 248);
	winTile.SetMinorSpacing(0);
	winTile.SetMargins(0,0);
	winTile.SetOrder(ORDER_Down);
        winTile.SetSensitivity(TRUE);
}

function TileWindow CreateScrollTileWindow(
	int posX, int posY,
	int sizeX, int sizeY)
{
	local TileWindow tileWindow;
	local PersonaScrollAreaWindow winScroll;

	winScroll = PersonaScrollAreaWindow(winClient.NewChild(Class'PersonaScrollAreaWindow'));
	winScroll.SetPos(posX, posY);
	winScroll.SetSize(sizeX, sizeY);

	tileWindow   = CreateTileWindow(winScroll.clipWindow);

	return tileWindow;
}


function TileWindow CreateTileWindow(Window parent)
{
	local TileWindow tileWindow;

	// Create Tile Window inside the scroll window
	tileWindow = TileWindow(parent.NewChild(Class'TileWindow'));
	tileWindow.SetFont(Font'FontMenuSmall');
	tileWindow.SetOrder(ORDER_Down);
	tileWindow.SetChildAlignments(HALIGN_Full, VALIGN_Top);
	tileWindow.MakeWidthsEqual(False);
	tileWindow.MakeHeightsEqual(False);

	return tileWindow;
}

function CreatePartsList()
{
	local CraftingPart CP;
	local IndiePartWindow I;

	if (bFilledList)
         return; //dont do this more than once

	// Iterate through the skills, adding them to our list
	/*aSkill = TNMDSSkillManager(TNMDreamScapePlayer(player).SkillSystem).FirstSkill;
	while(aSkill != None)
	{
		if (aSkill.SkillName != "")
		{
			skillButton = TNMDSPersonaSkillButtonWindow(winTile.NewChild(Class'TNMDSPersonaSkillButtonWindow'));
			skillButton.SetSkill(aSkill);

			skillButtons[buttonIndex++] = skillButton;

			if (firstButton == None)
				firstButton = skillButton;
		}
		aSkill = aSkill.next;
	}*/


	forEach Player.AllActors(class'CraftingPart', CP)
	{
		if (CP.Owner == Player)
		{
		 I = IndiePartWindow(winTile.NewChild(Class'IndiePartWindow'));
		 I.SetPart(CP);
		}
	}

	bFilledList = True;
}

function ResetList()
{
 if (GetNumParts(Player) == LastParts) return;
 
 bFilledList = False;
 
 WinTile.Hide();
 ChildRemoved(WinTile);
 //winTile.PopWindow();
 
 CreatePartsTileWindow();
 CreatePartsList();
 
 SetTitle("|p4"$GetNumParts(Player)$" Parts; "$Mutator.CurScrap$" Scrap");

 LastParts = GetNumParts(Player);
}

function int GetNumParts(DeusExPlayer P)
{
 local CraftingPart CP; //yea I know, sounds bad...
 local int i;
 
 forEach P.AllActors(class'CraftingPart', CP)
 {
  if (CP != None && CP.Owner == P)
  {
   i++;
  }
 }
  
 return i;
}

event InitWindow()
{
 local int j;
 local class<Inventory> TempItem;
 
	Super.InitWindow();
        exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);
        WorkbenchButton = winButtonBar.AddButton("|p4Access Workbench", HALIGN_Right);
	
	AddTimer(1, True,,'ResetList');
	
	CreatePartsTileWindow();
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch(buttonPressed)
	{
		/*case BuyButton:
			AttemptPurchase(CurPerk);
			bHandled = True;
			break;*/

		case exitButton:
			root.PopWindow();
			bHandled = True;
			break;

		case WorkbenchButton:
			InvokeWorkbenchMenu();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	if (buttonPressed.Isa('IndiePartWindow'))
	{
		Player.DropItem(IndiePartWindow(buttonPressed).Part, True);
		ResetList();
	}

       /*if (exitButton != buttonPressed)
       {
	UpdateInfo();
       }*/

	return bHandled;
}

function InvokeWorkbenchMenu()
{
	local WorkBenchMenuMain newWB;
	
	newWB = WorkBenchMenuMain(root.InvokeMenuScreen(Class'WorkBenchMenuMain'));
	
	if (newWB != None)
	{
		newWB.Player = Player;
		newWB.Bench = PartsBag;
		newWB.Mutator = Mutator;
		
		newWB.Last = Self;
		Show(False);
	}
}

     /*clientTextures(1)=Texture'DeusExUI.UserInterface.SkillsBackground_2'
     clientTextures(2)=Texture'DeusExUI.UserInterface.SkillsBackground_3'
     clientTextures(3)=Texture'DeusExUI.UserInterface.SkillsBackground_4'
     clientTextures(4)=Texture'DeusExUI.UserInterface.SkillsBackground_5'
     clientTextures(5)=Texture'DeusExUI.UserInterface.SkillsBackground_6'

     ClientWidth=604
     ClientHeight=361*/

defaultproperties
{
     Title="ERR"
     exitButtonText="Done"
     ClientWidth=384
     ClientHeight=256

     clientTextures(0)=Texture'PartsWindow384a'
     clientTextures(1)=Texture'PartsWindow384b'

     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=3
}
